import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';
import 'package:get/get.dart';
import 'package:play_lab/core/utils/dimensions.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/styles.dart';

class CustomRoundedButton extends StatelessWidget {
  final String text;
  final VoidCallback press;
  final Color color, textColor;
  final double verticalPadding;
  final double horizontalPadding;
  final double horizontalMargin;
  final double verticalMargin;
  final double radius;
  final bool isLoading;

  const CustomRoundedButton({
    super.key,
    required this.text,
    required this.press,
    this.color = MyColor.primaryColor,
    this.textColor = Colors.white,
    this.horizontalPadding = 10,
    this.verticalPadding = 18,
    this.horizontalMargin = 0,
    this.verticalMargin = 0,
    this.radius = 20,
    this.isLoading = false,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: press,
      child: Container(
        margin: EdgeInsets.symmetric(vertical: verticalMargin, horizontal: horizontalMargin),
        alignment: Alignment.center,
        padding: EdgeInsets.symmetric(horizontal: horizontalPadding, vertical: verticalPadding),
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(radius), color: color),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            if (isLoading)
              SizedBox(width: Dimensions.fontExtraLarge + 3, height: Dimensions.fontExtraLarge + 3, child: SpinKitFadingCircle(color: MyColor.colorWhite, size: Dimensions.fontExtraLarge + 3))
            else
              Text(
                text.tr,
                style: boldDefault.copyWith(color: textColor),
              ),
          ],
        ),
      ),
    );
  }
}
